using System;
using System.IO;

public class Program
{
  public static void Main(String[] args)
  {
    if(args.Length < 1)
    {
      Console.WriteLine("Wywołanie programu: Program plik");
      return;
    }
    String plik = args[0];
    FileInfo fi;

    try
    {
      fi = new FileInfo(plik);
    }
    catch(ArgumentException)
    {
      Console.WriteLine(
        "Nazwa {0} zawiera nieprawidłowe znaki.", plik);
      return;
    }

    if(!fi.Exists)
    {
      Console.WriteLine("Plik {0} nie istnieje.", plik);
      return;
    }
    Console.WriteLine("Dane o pliku {0}: ", plik);
    Console.WriteLine("Atrybuty: {0}", fi.Attributes);
    Console.WriteLine("Katalog: {0}", fi.Directory);
    Console.WriteLine("Rozszerzenie: {0}", fi.Extension);
    Console.WriteLine("Ścieżka: {0}", fi.FullName);
    Console.WriteLine("Długość: {0}", fi.Length);
    Console.WriteLine("Data utworzenia: {0}", fi.CreationTime);
    Console.WriteLine("Data ostatniej modyfikacji: {0}", fi.LastWriteTime);
    Console.WriteLine("Data ostatniego dostępu: {0}", fi.LastAccessTime);
  }
}
